/* File: "bq27x10.h" */

/************************************************************
* STANDARD BITS
************************************************************/
#define BIT0 (0x0001)
#define BIT1 (0x0002)
#define BIT2 (0x0004)
#define BIT3 (0x0008)
#define BIT4 (0x0010)
#define BIT5 (0x0020)
#define BIT6 (0x0040)
#define BIT7 (0x0080)
#define BIT8 (0x0100)
#define BIT9 (0x0200)
#define BITA (0x0400)
#define BITB (0x0800)
#define BITC (0x1000)
#define BITD (0x2000)
#define BITE (0x4000)
#define BITF (0x8000)

#define bq27x10CMD_CTRL      0x00
#define bq27x10CMD_MODE      0x01
#define bq27x10CMD_AR_LSB    0x02
#define bq27x10CMD_AR_MSB    0x03
#define bq27x10CMD_ARTTE_LSB 0x04
#define bq27x10CMD_ARTTE_MSB 0x05
#define bq27x10CMD_TEMP_LSB  0x06
#define bq27x10CMD_TEMP_MSB  0x07
#define bq27x10CMD_VOLT_LSB  0x08
#define bq27x10CMD_VOLT_MSB  0x09
#define bq27x10CMD_FLAGS     0x0A
#define bq27x10CMD_RSOC      0x0B
#define bq27x10CMD_NAC_LSB   0x0C
#define bq27x10CMD_NAC_MSB   0x0D
#define bq27x10CMD_LMD_LSB   0x0E
#define bq27x10CMD_LMD_MSB   0x0F
#define bq27x10CMD_CAC_LSB   0x10
#define bq27x10CMD_CAC_MSB   0x11
#define bq27x10CMD_FCAC_LSB  0x12
#define bq27x10CMD_FCAC_MSB  0x13
#define bq27x10CMD_AI_LSB    0x14
#define bq27x10CMD_AI_MSB    0x15
#define bq27x10CMD_TTE_LSB   0x16
#define bq27x10CMD_TTE_MSB   0x17
#define bq27x10CMD_TTF_LSB   0x18
#define bq27x10CMD_TTF_MSB   0x19
#define bq27x10CMD_SI_LSB    0x1A
#define bq27x10CMD_SI_MSB    0x1B
#define bq27x10CMD_STTE_LSB  0x1C
#define bq27x10CMD_STTE_MSB  0x1D
#define bq27x10CMD_CEDV_LSB  0x20
#define bq27x10CMD_CEDV_MSB  0x21
#define bq27x10CMD_TTECP_LSB 0x26
#define bq27x10CMD_TTECP_MSB 0x27
#define bq27x10CMD_CYCL_LSB  0x28
#define bq27x10CMD_CYCL_MSB  0x29
#define bq27x10CMD_CYCT_LSB  0x2A
#define bq27x10CMD_CYCT_MSB  0x2B
#define bq27x10CMD_CSOC      0x2C
#define bq27x10CMD_EE_EN     0x6E
#define bq27x10CMD_ILMD      0x76
#define bq27x10CMD_SEDVF     0x77
#define bq27x10CMD_SEDV1     0x78
#define bq27x10CMD_ISLC_EDVT 0x79
#define bq27x10CMD_DMFSD     0x7A
#define bq27x10CMD_TAPER     0x7B
#define bq27x10CMD_PKCFG     0x7C
#define bq27x10CMD_GAF_DEDV  0x7D
#define bq27x10CMD_DCOMP     0x7E
#define bq27x10CMD_TCOMP     0x7F

// When CTRL COMMAND KEY = 0xA9 ...
#define bq27x10REG_MODE_GPIEN  BIT7
#define bq27x10REG_MODE_GPSTAT BIT6
#define bq27x10REG_MODE_WRTNAC BIT5
#define bq27x10REG_MODE_DONE   BIT4
#define bq27x10REG_MODE_PRST   BIT3
#define bq27x10REG_MODE_INIT   BIT2
#define bq27x10REG_MODE_FRST   BIT1
#define bq27x10REG_MODE_SHIP   BIT0

// When CTRL COMMAND KEY = 0x56 ...
#define bq27x10REG_MODE_GPIEN  BIT7
#define bq27x10REG_MODE_GPSTAT BIT6
#define bq27x10REG_MODE_CEO    BIT5
#define bq27x10REG_MODE_CIO    BIT4
#define bq27x10REG_MODE_WNACCI BIT3
#define bq27x10REG_MODE_INIT   BIT2
#define bq27x10REG_MODE_WRTCYC BIT1
#define bq27x10REG_MODE_WRTLMD BIT0

// When CTRL COMMAND KEY = 0xC5 ...
#define bq27x10REG_MODE_GPIEN  BIT7
#define bq27x10REG_MODE_GPSTAT BIT6
#define bq27x10REG_MODE_UPDC   BIT5
#define bq27x10REG_MODE_UPEDVI BIT4
#define bq27x10REG_MODE_UPDMF  BIT3
#define bq27x10REG_MODE_INIT   BIT2
#define bq27x10REG_MODE_UPCFG  BIT1
#define bq27x10REG_MODE_UPCOMP BIT0

// Status Flag Register (FLAGS)
#define bq27x10REG_FLAGS_CHGS  BIT7
#define bq27x10REG_FLAGS_NOACT BIT6
#define bq27x10REG_FLAGS_IMIN  BIT5
#define bq27x10REG_FLAGS_CI    BIT4
#define bq27x10REG_FLAGS_CALIP BIT3
#define bq27x10REG_FLAGS_VDQ   BIT2
#define bq27x10REG_FLAGS_EDV1  BIT1
#define bq27x10REG_FLAGS_EDVF  BIT0
